/*
CartoTypeInternal.h
Copyright 2011-2024 CartoType Ltd.
See www.cartotype.com for more information.
*/

/**
\file
Helper functions for the CartoType iOS API.
*/

#ifndef CartoTypeInternal_h__
#define CartoTypeInternal_h__

#import <Foundation/Foundation.h>
#import <CoreGraphics/CGGeometry.h>

#import <CartoType/CartoTypeBase.h>
#include <cartotype_framework.h>

inline NSString* MakeString(const CartoTypeCore::MString& aString)
    {
    unichar x;
    const unsigned short* text = aString.Data();
    if (text == nullptr)
        text = &x;
    return [[NSString alloc] initWithCharacters:text length:aString.Length()];
    }

inline CtRect MakeRect(const CartoTypeCore::Rect& aRect)
    {
    CtRect r;
    r.minX = aRect.Min.X;
    r.minY = aRect.Min.Y;
    r.maxX = aRect.Max.X;
    r.maxY = aRect.Max.Y;
    return r;
    }

inline CartoTypeCore::Rect MakeRect(const CtRect& aRect)
    {
    CartoTypeCore::Rect r;
    r.Min.X = CartoTypeCore::Round(aRect.minX);
    r.Min.Y = CartoTypeCore::Round(aRect.minY);
    r.Max.X = CartoTypeCore::Round(aRect.maxX);
    r.Max.Y = CartoTypeCore::Round(aRect.maxY);
    return r;
    }

inline void SetAddress(CtAddress* aDest,CartoTypeCore::Address& aSource)
    {
    aDest.building = MakeString(aSource.Building);
    aDest.feature = MakeString(aSource.Feature);
    aDest.street = MakeString(aSource.Street);
    aDest.subLocality = MakeString(aSource.SubLocality);
    aDest.locality = MakeString(aSource.Locality);
    aDest.island = MakeString(aSource.Island);
    aDest.subAdminArea = MakeString(aSource.SubAdminArea);
    aDest.adminArea = MakeString(aSource.AdminArea);
    aDest.country = MakeString(aSource.Country);
    aDest.postCode = MakeString(aSource.PostCode);
    }

inline void GetAddress(CartoTypeCore::Address& aDest,CtAddress* aSource)
    {
    aDest.Clear();
    if (aSource.building)
        aDest.Building.Set([aSource.building UTF8String]);
    if (aSource.feature)
        aDest.Feature.Set([aSource.feature UTF8String]);
    if (aSource.street)
        aDest.Street.Set([aSource.street UTF8String]);
    if (aSource.subLocality)
        aDest.SubLocality.Set([aSource.subLocality UTF8String]);
    if (aSource.locality)
        aDest.Locality.Set([aSource.locality UTF8String]);
    if (aSource.island)
        aDest.Island.Set([aSource.island UTF8String]);
    if (aSource.subAdminArea)
        aDest.SubAdminArea.Set([aSource.subAdminArea UTF8String]);
    if (aSource.adminArea)
        aDest.AdminArea.Set([aSource.adminArea UTF8String]);
    if (aSource.country)
        aDest.Country.Set([aSource.country UTF8String]);
    if (aSource.postCode)
        aDest.PostCode.Set([aSource.postCode UTF8String]);
    }

void throwError(unsigned int aError);

#endif
