/*
CartoTypeFrameworkParam.h
Copyright (C) CartoType Ltd 2015-2024.
See www.cartotype.com for more information.
*/

#ifndef CartoTypeFrameworkParam_h__
#define CartoTypeFrameworkParam_h__

#import <Foundation/Foundation.h>

/**
\file
Parameters for creating a CtFramework object.
*/

/**
Parameters for creating a CtFramework object when detailed control is needed.
For example, file buffer size and the maximum number of buffers can be set.
*/
@interface CtFrameworkParam: NSObject

/** Creates a CtFrameworkParam object. */
-(id)init;

/** The map. Must not be null or empty. */
@property (nonatomic, strong) NSString* mapFileName;
/** The style sheet. If it is null or empty, styleSheetText is used. */
@property (nonatomic, strong) NSString* styleSheetFileName;
/** The style sheet text. Used if styleSheetFileName is null or empty. */
@property (nonatomic, strong) NSString* styleSheetText;
/** The font file. Must not be null or empty. */
@property (nonatomic, strong) NSString* fontFileName;
/** The width of the map in pixels. Must be greater than zero. */
@property (nonatomic) int viewWidth;
/** The height of the map in pixels. Must be greater than zero. */
@property (nonatomic) int viewHeight;
/** If non-null, an API key or encryption key to be used when loading the map. */
@property (nonatomic, strong) NSString* key;
/** The file buffer size in bytes. If it is zero or less the default value is used. */
@property (nonatomic) int fileBufferSizeInBytes;
/** The maximum number of file buffers. If it is zero or less the default value is used. */
@property (nonatomic) int maxFileBufferCount;
/**
The number of levels of the text index to load into RAM.
Use values from 1 to 5 to save RAM but make text searches slower.
The value 0 causes the default number of levels (6) to be loaded.
The value -1 disables text index loading.
*/
@property (nonatomic) int textIndexLevels;

@end
/** A synonym of CtFrameworkParam. */
@compatibility_alias CartoTypeFrameworkParam CtFrameworkParam;

#endif

