/*
CartoTypeView.h
Copyright 2019-2024 CartoType Ltd.
See www.cartotype.com for more information.
*/

#import <CartoType/CartoType.h>
#import <CartoType/CartoTypeFramework.h>
#import <CartoType/MGLKit.h>

/**
\file
A graphics-accelerated view class.
*/

/**
A view class for drawing maps using graphics acceleration.
Objects of this class may be used directly, but it is easier to use
CtViewController, which creates and manages a CtView.
*/
@interface CtView: MGLKView

/** Sets the CtFramework to be drawn. */
-(void)setFramework:(CtFramework*)aFramework;

/** Draws the current CtFramework. */
-(void)drawRect:(CGRect)rect;

@end

/** A synonym of CtView. */
@compatibility_alias CartoTypeView CtView;
