/*
CartoTypeFrameworkParam.h
Copyright (C) CartoType Ltd 2015-2024.
See www.cartotype.com for more information.
*/

#ifndef CartoTypeFrameworkParam_h__
#define CartoTypeFrameworkParam_h__

#import <Foundation/Foundation.h>

/**
\file
Parameters for creating a CtFramework object.
*/

/** Policies used to load and cache files. */
typedef NS_ENUM(NSInteger,CtFilePolicy)
    {
    /** The default policy. */
    CtFilePolicyDefault = 0,
    /** Each file has a cache that is shared among threads. */
    CtFilePolicyCache = 1,
    /** A single cache is used, shared among all files and all threads. */
    CtFilePolicySharedCache = 2,
    /** A memory map is created for the file. */
    CtFilePolicyMemoryMap = 3,
    /** Each file has a single 64K buffer. */
    CtFilePolicySimple = 4
    };
/** A synonym of CtFilePolicy. */
typedef CtFilePolicy CartoTypeFilePolicy;

/**
Parameters for creating a CtFramework object when detailed control is needed.
For example, file buffer size and the maximum number of buffers can be set.
*/
@interface CtFrameworkParam: NSObject

/** The map. Must not be null or empty. */
@property (nonatomic, strong) NSString* mapFileName;
/** The style sheet. If it is null or empty, styleSheetText is used. */
@property (nonatomic, strong) NSString* styleSheetFileName;
/** The style sheet text. Used if styleSheetFileName is null or empty. */
@property (nonatomic, strong) NSString* styleSheetText;
/** The font file. Must not be null or empty. */
@property (nonatomic, strong) NSString* fontFileName;
/** The width of the map in pixels. Must be greater than zero. */
@property (nonatomic) int viewWidth;
/** The height of the map in pixels. Must be greater than zero. */
@property (nonatomic) int viewHeight;
/** If non-null, an API key or encryption key to be used when loading the map. */
@property (nonatomic, strong) NSString* key;
/** The file policy used for the map file. */
@property (nonatomic) CtFilePolicy mapFilePolicy;

@end
/** A synonym of CtFrameworkParam. */
@compatibility_alias CartoTypeFrameworkParam CtFrameworkParam;

#endif

